<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <!--
BOSCH Security Sytems (Grassbrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 25.2.2011

$Revision: 1.1 $ 

Last locked:   $Date: 2011/02/25 15:24:49MEZ $

Last change by $Author: Michael Ziegel (zi82ot) $

History: 
$Log: prepareBasic.xsl  $
Revision 1.1 2011/02/25 15:24:49MEZ Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Testing/DownUpTest/DownUpTest.pj
-->
   <xsl:param name="RemoveAttributes" select="'true'"/>
   <xsl:output method="xml" indent="yes"/>
   <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
   <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
   <xsl:template match="*">
      <xsl:element name="{name()}">
         <!-- RPS writes newlines into empty elements sometimes -->
         <xsl:choose>
            <xsl:when test="./* = false()">
               <xsl:value-of select="normalize-space(.)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
   <!-- explicitly copy attributes -->
   <xsl:template match="@*">
      <xsl:if test="$RemoveAttributes = 'false'">
         <xsl:copy/>
      </xsl:if>
   </xsl:template>
   <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
</xsl:stylesheet>
